<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use App\Models\User;
use App\Models\Realtors;

class RealtorController extends Controller {

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        $this->middleware('auth');
        $this->middleware('role:admin'); // Ensure only admin users can access this controller
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function add() {
        return view('admin.realtor.add');
    }

    public function store(Request $request): RedirectResponse {
        // Define your validation rules
        $validated = $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'location' => 'required|string|max:255',
            'category' => 'required',
        ]);

        if ($validated) {
            // Create a new User model and fill it with the relevant data
            $user = new User();
            $user->name = $request->input('firstname'); // Store first name as name
            $user->email = $request->input('email');
            $user->password = bcrypt('12345678'); // Store '12345678' as the hashed password
            $user->roleid = 2; // Set the role to 2 (assuming 2 represents the desired role)
            // Save the User model to the database
            $user->save();

            // Now that we have a User ID, create a new Realtor model and fill it with the rest of the data
            $realtor = new Realtors();
            $realtor->user_id = $user->id; // Assign the User ID to the realtor's user_id
            $realtor->firstname = $request->input('firstname');
            $realtor->lastname = $request->input('lastname');
            $realtor->phone = $request->input('phone');
            $realtor->email = $request->input('email');
            $realtor->location = $request->input('location');
            $realtor->category = $request->input('category');

            // Save the Realtor model to the database
            $realtor->save();

            // Redirect back with a success message
            return redirect()->route('edit.realtor')->with('success', 'Realtor added successfully.');
        }
    }

    public function edit() {
        // Define the number of records per page
        $perPage = 10; // You can adjust this value as needed
        // Retrieve paginated realtors data from the database
        $realtors = Realtors::with('user')->paginate($perPage);

        // Pass the paginated realtors data to the view
        return view('admin.realtor.edit', compact('realtors'));
    }

    public function updateUserActivity(Request $request) {
        $userId = $request->input('userId');
        $isActive = $request->input('isActive');

        // Update the user's activity status in the database
        User::where('id', $userId)->update(['is_active' => $isActive]);

        // You can return a response if needed
        return response()->json(['message' => 'User activity updated successfully']);
    }
}
