<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use App\Models\User;

class LoginController extends Controller {
    /*
      |--------------------------------------------------------------------------
      | Login Controller
      |--------------------------------------------------------------------------
      |
      | This controller handles authenticating users for the application and
      | redirecting them to your home screen. The controller uses a trait
      | to conveniently provide its functionality to your applications.
      |
     */

use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        $this->middleware('guest')->except('logout');
    }
    
    // Override the attemptLogin method
    protected function attemptLogin(Request $request)
    {
        // Check if the user exists and is active
        $credentials = $this->credentials($request);
        $user = User::where('email', $credentials[$this->username()])->first();

        if ($user && $user->is_active === 1) {
            return $this->guard()->attempt(
                $credentials,
                $request->filled('remember')
            );
        }

        return false; // User is not active or doesn't exist
    }
    
     protected function sendFailedLoginResponse(Request $request)
    {
        throw ValidationException::withMessages([
            $this->username() => [trans('Your account on hold, contact admin')],
        ]);
    }

    protected function authenticated(Request $request, $user) {
        
        // Check the user's role and redirect based on the role
        if ($user->hasRole('investor')) {
            return redirect()->route('investor.dashboard');
        }
        if ($user->hasRole('admin')) {
            return redirect()->route('dashboard');
        }

        // Default redirect for other roles
        return redirect($this->redirectTo);
    }

    public function logout(Request $request) {
        Auth::logout(); // Log the user out

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/login'); // Redirect the user to the login page
    }
}
