<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deal extends Model {

    use HasFactory;

    protected $dates = ['start_date', 'end_date'];
    protected $fillable = ['deal_name', 'total_investment', 'category_id', 'start_date', 'end_date'];

    // Define the relationship with the Category model
    public function category() {
        return $this->belongsTo(Category::class, 'category_id');
    }

    /**
     * Define a has many relationship with DealDocument.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function dealDocuments() {
        return $this->hasMany(DealDocuments::class);
    }

    /**
     * Define a has many relationship with DealInvestments.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function dealInvestments() {
        return $this->hasMany(DealInvestments::class, 'deal_id');
    }
    
    public function investors()
    {
        return $this->hasMany(Investors::class, 'investor_id');
    }

}
