<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DealInvestments extends Model {

    protected $fillable = ['user_id', 'deal_id', 'investor_id', 'invested_amt', 'invested_on', 'updated_by'];

    use HasFactory;

    public function user() {
        return $this->belongsTo(User::class, 'investor_id');
    }

    public function deals() {
        return $this->belongsTo(Deal::class, 'deal_id');
    }

    public function investors() {
        return $this->belongsTo(Investors::class, 'investor_id');
    }
}
