<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Investors extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'user_id',  // Add 'user_id' to the list of fillable fields
        'investorid',
        'firstname',
        'lastname',
        'email',
        'phone',
        // Add other fields here
    ];
    
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    
    public function dealInvestments()
    {
        return $this->hasMany(DealInvestments::class, 'investor_id', 'user_id');
    }
}
