@extends('layouts.app_backend')

@section('content')
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<div class="container-full">
    <section class="content">
        <div class="callout callout-success" style="display: none;">

        </div>
        @if(session('success'))
        <div class="card card-body" id="success-card">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> {{ session('success') }}
            </div>
        </div>

        <script>
// Auto close the success alert card after 5 seconds
setTimeout(function () {
$('#success-card').fadeOut();
}, 5000);
        </script>
        @endif
        <div class="box">
            <div class="box-body">
                <div class="px-20 bb-1 pb-15 d-flex align-items-center justify-content-between">
                    <h4 class="mb-0">{{ $deal->deal_name }}</h4>
                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="waves-effect waves-light mx-10 btn btn-sm btn-primary">{{ $deal->total_investment }}</button>
                        <button type="button" class="waves-effect waves-light btn btn-sm btn-primary-light">{{ $deal->created_at->format('d-m-y') }}</button>
                        <a href="{{ route('add.investment') }}" class="waves-effect mx-10  waves-light btn btn-sm btn-success">ADD MORE INVESTORS</a>
                        <a href="{{ route('admin.deal.documents', ['dealid' => $deal->id]) }}" class="waves-effect mx-10  waves-light btn btn-sm btn-warning">ADD Documents</a>
                    </div>
                </div>
            </div>

            <div class="box-body">
                <div class="row">
                    <div class="col col-5">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="">Documents</h4>
                            </div>
                            <div class="box-body">	
                                @if(count($dealDocuments) > 0)
                                @foreach($dealDocuments as $document)
                                <div class="mb-10 d-flex justify-content-between align-items-center">
                                    <div class="fw-600 min-w-120">
                                        <i class="fa-solid fa-arrow-up"></i> {{ $document->created_at->format('d-m-y') }} <!-- Display the document creation date -->
                                    </div>
                                    <div class="w-p100 p-10 rounded10 justify-content-between align-items-center d-flex bg-lightest">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <h6 class="mb-0" style="text-transform: uppercase;">{{ $document->document_name }}</h6>
                                            </div>
                                        </div>
                                        <div class="dropdown">
                                            <a data-bs-toggle="dropdown" href="#"><i class="ti-more-alt rotate-90"></i></a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <!-- Provide a link to download the document PDF -->
                                                <a class="dropdown-item" href="{{ route('admin.download.document', ['filename' => $document->document_file, 'filetyp' => 'docx']) }}" target="_blank"><i class="ti-import"></i> Download</a>
                                                <a class="dropdown-item" href="" onclick="docDelete({{ $document->id }})"><i class="ti-trash"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                @else
                                <div class="media flex-column text-center p-40 bg-gray-100 mb-20">
                                    <span class="avatar avatar-xl bg-warning opacity-60 mx-auto">
                                        <i class="align-sub fa-solid fa-x fs-40"></i>
                                    </span>
                                    <div class="mt-20">
                                        <h6 class="text-uppercase fw-500">SORRY!</h6>
                                        <small>You haven't uploaded any yet.</small>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col col-7">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="">Investments</h4>
                            </div>
                            <div class="box-body">
                                <div class="inner-user-div4">
                                    @if(count($investments) > 0)
                                    @foreach($investments as $investment)
                                    <div>
                                        <div class="d-flex align-items-center mb-10">
                                            <div class="me-15">
                                                <img src="https://www.pngall.com/wp-content/uploads/5/Profile-Male-PNG.png" class="avatar avatar-lg rounded10 bg-primary-light" alt="" />
                                            </div>
                                            <div class="d-flex flex-column flex-grow-1 fw-500">
                                                <p class="hover-primary text-fade mb-1 fs-14">Investor</p>
                                                <span class="text-dark fs-16">{{ $investment->user->name }}</span> <!-- Display user's name -->
                                            </div>
                                            <div>
                                                <a href="#" class="waves-effect waves-circle btn btn-circle btn-primary-light btn-sm"><i class="fa fa-phone"></i></a>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-end mb-15 py-10 bb-dashed border-bottom">
                                            <div>
                                                <p class="mb-0 text-muted"><i class="fa fa-clock-o me-5"></i>{{ $investment->invested_on }}<span class="mx-20">${{ $investment->invested_amt }}</span></p> <!-- Display invested_on and invested_amt -->
                                            </div>
                                            <div>
                                                <div class="dropdown">
                                                    <a data-bs-toggle="dropdown" href="#" class="base-font mx-10"><i class="ti-more-alt text-muted"></i></a>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a class="dropdown-item edit-investment" data-investment-id="{{ $investment->id }}" href="#" data-bs-toggle="modal" data-bs-target="#modal-center">
                                                            <i class="ti-pencil"></i> Edit Data
                                                        </a>

                                                        <a class="dropdown-item" href="#" onclick="confirmDelete({{ $investment->id }})"><i class="ti-trash"></i> Delete</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    @else
                                    <div class="media flex-column text-center p-40 bg-gray-100 mb-20">
                                        <span class="avatar avatar-xl bg-warning opacity-60 mx-auto">
                                            <i class="align-sub fa-solid fa-x fs-40"></i>
                                        </span>
                                        <div class="mt-20">
                                            <h6 class="text-uppercase fw-500">SORRY!</h6>
                                            <small>No investor has been assigned yet.</small>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
    </section>
</div>
<!-- Modal -->
<div class="modal fade" id="modal-center" tabindex="-1" aria-labelledby="modal-center-title" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modal-center-title">Edit 
                    <span id="investorName" style="text-transform: uppercase; font-weight: 600;"></span> Investment Data
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Edit form goes here -->
                <form id="editInvestmentForm">
                    @csrf
                    <input type="hidden" id="investmentId" name="investment_id" value="">
                    <div class="mb-3">
                        <label for="investedAmt" class="form-label">Invested Amount</label>
                        <input type="text" class="form-control" id="investedAmt" name="invested_amt">
                    </div>
                    <div class="mb-3">
                        <label for="investedOn" class="form-label">Invested On</label>
                        <input type="date" class="form-control" id="investedOn" name="invested_on">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="saveInvestmentBtn">Save changes</button>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function confirmDelete(dealId) {
        var confirmation = confirm("Are you sure you want to delete this investor?");
        if (confirmation) {
            // User clicked "OK," navigate to the delete route
            window.location.href = "{{ route('admin.deal.assign.destroy', '') }}/" + dealId;
        } else {
            // User clicked "Cancel," do nothing
        }
    }
    
    function docDelete(docId) {
        var confirmation = confirm("Are you sure you want to delete this document?");
        if (confirmation) {
            // User clicked "OK," navigate to the delete route
            window.location.href = "{{ route('admin.destroy.dealDocument', '') }}/" + docId;
        } else {
            // User clicked "Cancel," do nothing
        }
    }

    $(document).ready(function () {
    // Handle click on the edit icon
    $('.edit-investment').click(function () {
    // Get the investment ID from the data-investment-id attribute
    var investmentId = $(this).data('investment-id');
    $.ajax({
    url: "{{ route('get.investment.data') }}",
            method: 'POST',
            data: {
            '_token': '{{ csrf_token() }}', // Include the CSRF token for Laravel
                    'investment_id': investmentId
            },
            success: function(data) {
            console.log(data.invested_amt);
            // Populate the modal fields with data received from the server
            if (data.length > 0) {
            // Populate the modal fields with data from the first item
            $('#investedAmt').val(data[0].invested_amt);
            $('#investedOn').val(data[0].invested_on);
            $('#investmentId').val(investmentId);
            // Set the modal title to the name of the first investor
            $('#modal-center-title #investorName').text(data[0].user.name);
            }
            },
            error: function(xhr, status, error) {
            // Handle errors if necessary
            }
    });
    });
    });
    document.getElementById('saveInvestmentBtn').addEventListener('click', function() {
    // Get the investment_id from your data source (e.g., a data attribute)

    // Set the investment_id in the hidden input field
    investmentId = document.getElementById('investmentId').value;
    var csrfToken = document.querySelector('input[name="_token"]').value;
    // Get the form data
    var formData = {
    _token: csrfToken, // Include the CSRF token in the form data
            invested_amt: document.getElementById('investedAmt').value,
            invested_on: document.getElementById('investedOn').value,
            investment_id: investmentId, // Include the investment_id in the form data
    };
    // Send an AJAX request to save the data
    $.ajax({
    url: "{{ route('update.investment') }}",
            method: 'POST',
            data: formData,
            success: function(response) {
            // Handle success (e.g., close the modal, show a success message)
            $('#modal-center').modal('hide');
            $('.callout-success').css("display", "block");
            $('.callout-success').text(response.message);
            setTimeout(function() {
            location.reload();
            }, 1000);
            },
            error: function(xhr, status, error) {
            // Handle errors (e.g., display an error message)
            console.error(error);
            }
    });
    });
</script>
@endsection


