@extends('layouts.app_backend')

@section('content')
<div class="container-fluid">
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="me-auto">
                <div class="d-inline-block align-items-center">
                    <nav>
                        <ol class="breadcrumb">
                            <li><a href="#">Home<i class="fa-solid fa-angles-right"></i></a></li>
                            <li><a href="#"> Deal<i class="fa-solid fa-angles-right"></i></a></li>
                            <li ><a href="#" class="breadcrumb-active">Add Deal Document</a></li>
                        </ol>
                    </nav>
                </div>
            </div>

        </div>
    </div>
    <section class="content">
        <div class="row justify-content-center">
            <div class="col-12 col-md-12 col-lg-5">
                <div class="box">
                    <div class="box-header with-border">
                        <h4 class="box-title">ADD DEAL DOCUMENTS</h4>
                    </div>

                    <div class="box-body ms-30">
                        <div class="row" id="document-rows">
                            <div class="col">
                                <form method="POST" action="{{ route('admin.deal.documents.store') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row mb-2">
                                        <div class="col-md-9 form-group">
                                            <label for "deals">Deals</label>
                                            <select name="deal_id" id="deal_id" class="form-select form-control">
                                                <option value="">Select Deal</option>
                                                @foreach($deals as $deal)
                                                <option value="{{ $deal->id }}" {{ (old('deal_id') == $deal->id || request('dealid') == $deal->id) ? 'selected' : '' }} {{ (request('dealid') == $deal->id) ? '' : 'disabled' }}>
                                                    {{ $deal->deal_name }}
                                                </option>
                                                @endforeach
                                            </select>
                                            @error('deal_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>


                                    <div class="row mb-2 documents-block">
                                        <div class="col-md-9 form-group">
                                            <label for="document_name">Document Name</label>
                                            <input type="text" name="document_name[]" class="form-control" placeholder="deal document"> 
                                        </div>
                                        <div class="col-md-9 form-group">
                                            <label for="document_file">Upload File</label>
                                            <input type="file" name="document_files[]" class="form-control"> 
                                        </div>
                                        <div class="col-md-3 form-group mt-4">
                                            <button type="button" id="more-documents" class="btn btn-info text-white"><i class="fa-solid fa-plus"></i></button>
                                            <button type="button" class="btn btn-danger remove-document text-white"><i class="fa-solid fa-trash"></i></button>
                                        </div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-success text-white">ADD DOCUMENTS</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
    $(document).ready(function () {
        // Event delegation for dynamically added "More documents" buttons
        $(document).on('click', '#more-documents', function () { // Change this line
            // Clone the documents-block div
            var clonedBlock = $('.documents-block:last').clone();

            // Clear input values in the cloned block
            clonedBlock.find('input').val('');
            clonedBlock.find('select').val('');

            // Add the cloned block after the last documents-block div
            $('.documents-block:last').after(clonedBlock);

            // Display the remove-document button in the cloned block
            clonedBlock.find('.remove-document').show();
        });

        // Event delegation for dynamically added "Remove documents" buttons
        $(document).on('click', '.remove-document', function () { // Change this line
            var result = confirm("Are you sure you want to remove this document?");
            if (result) {
                // Remove the corresponding documents-block div
                $(this).closest('.documents-block').remove();
            }
        });
    });
</script>
<style>
    .remove-document {
        display: none; /* Initially hidden */
    }
</style>
@endsection