@extends('layouts.app_backend')

@section('content')
<div class="container-fluid">
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="me-auto">
                <div class="d-inline-block align-items-center">
                    <nav>
                        <ol class="breadcrumb">
                            <li><a href="#">Home<i class="fa-solid fa-angles-right"></i></a></li>
                            <li><a href="#"> Investor<i class="fa-solid fa-angles-right"></i></a></li>
                            <li ><a href="#" class="breadcrumb-active">Add Investor</a></li>
                        </ol>
                    </nav>
                </div>
            </div>

        </div>
    </div>
    <section class="content">
        <div class="row justify-content-center">
            <div class="col-12 col-md-12 col-lg-5">
                <div class="box">
                    <div class="box-header with-border">
                        <h4 class="box-title">ADD NEW INVESTOR</h4>
                    </div>

                    <div class="box-body ms-10">
                        <div class="row">
                            <div class="col">
                                <form method="POST" action="{{ route('save.investors') }}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-12 form-group">
                                            <label for="deal_name">First Name</label>
                                            <input type="text" name="firstname" value="{{ old('firstname') }}" placeholder="Enter firstname" class="form-control @error('firstname') is-invalid @enderror">
                                            @error('firstname')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="deal_name">Last Name</label>
                                            <input type="text" name="lastname" value="{{ old('lastname') }}" placeholder="Enter lastaname" class="form-control @error('lastname') is-invalid @enderror">
                                            @error('lastname')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="total_investment">Email Address</label>
                                            <input type="email" name="email" value="{{ old('email') }}" placeholder="Enter email address" class="form-control @error('email') is-invalid @enderror">
                                            @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="deal_name">Phone Number</label>
                                            <input type="text" name="phone" value="{{ old('phone') }}" placeholder="Enter phone number" class="form-control @error('phone') is-invalid @enderror">
                                            @error('phone')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="password">{{ __('Password') }}</label>
                                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror"  placeholder="Enter password" name="password" autocomplete="new-password">
                                            @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="password-confirm">{{ __('Confirm Password') }}</label>
                                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation"  placeholder="Enter confrim password" autocomplete="new-password">
                                        </div>

                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-info">ADD INVESTOR</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
