@extends('layouts.app_investor')

@section('content')

<div class="container-full">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h4 class="box-title">All Deals</h4>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="myinvestments" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Deal Name</th>
                                        <th>Deal Start Date</th>
                                        <th>Deal Close Date</th>
                                        <th>Total Invested</th>
                                        <th>Investment Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($investments as $investment)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><strong><a href="{{ route('investor.deal.details', $investment->deal_id) }}">{{ $investment->deals->deal_name }}</a></strong></td>
                                        <td>{{ $investment->deals->start_date }}</td>
                                        <td>{{ $investment->deals->end_date }}</td>
                                        <td>{{ $investment->invested_amt }}</td>
                                        <td>{{ $investment->invested_on }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="box-footer bg-light py-10 with-border">
                        <div class="d-flex align-items-center justify-content-between">
                            <p class="mb-0">Total {{ count($investments) }} Investors</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>			
    </section>
    <!-- /.content -->
</div>

<script>
    $('#myinvestments').DataTable();
</script>
@endsection