@extends('layouts.app_investor')

@section('content')
<div class="container-full">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h4 class="box-title">All Investments</h4>
                    </div>
                    <div class="box-body no-padding">
                        <div class="table-responsive">
                            <table id="myinvestments" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Invested</th>
                                        <th>Investment On</th>
                                        <th>Deal Name</th>
                                        <th>Deal Start Date</th>
                                        <th>Deal Close Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($investments as $investment)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $investment->invested_amt }}</td>
                                        <td>{{ $investment->invested_on }}</td>
                                        <td><strong><a href="{{ route('investor.deal.details', $investment->deal_id) }}">{{ $investment->deals->deal_name }}</a></strong></td>
                                        <td>{{ $investment->deals->start_date }}</td>
                                        <td>{{ $investment->deals->end_date }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>			
    </section>
    <!-- /.content -->
</div>
@endsection