@extends('layouts.app_investor')

@section('content')
<div class="container-fluid">
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="me-auto">
                <div class="d-inline-block align-items-center">
                    <nav>
                        <ol class="breadcrumb">
                            <li><a href="#">Home<i class="fa-solid fa-angles-right"></i></a></li>
                            <li ><a href="#" class="breadcrumb-active">Profile</a></li>
                        </ol>
                    </nav>
                </div>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12 col-lg-5 col-xl-4">
                <div class="box box-widget widget-user">
                    <!-- Add the bg color to the header using any of the bg-* classes -->
                    <div class="widget-user-header bg-img bbsr-0 bber-0" data-overlay="5">
                        <h3 class="widget-user-username text-white">{{ $profile->firstname }} {{ $profile->lastname }}</h3>
                    </div>
                    <div class="widget-user-image">
                        <img class="rounded-circle" src="https://www.pngall.com/wp-content/uploads/5/Profile-Male-PNG.png" alt="User Avatar">
                    </div>
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="description-block">
                                    <h5 class="description-header">{{ $investments }}</h5>
                                    <span class="description-text">DEALS</span>
                                </div>
                                <!-- /.description-block -->
                            </div>
                            <!-- /.col -->
                            <div class="col-sm-4 be-1 bs-1">
                                <div class="description-block">
                                    <h5 class="description-header">{{ $totalIInvestment }}</h5>
                                    <span class="description-text">INVESTED</span>
                                </div>
                                <!-- /.description-block -->
                            </div>
                            <!-- /.col -->
                            <div class="col-sm-4">
                                <div class="description-block">
                                    <h5 class="description-header">1X</h5>
                                    <span class="description-text">MULTIPLE</span>
                                </div>
                                <!-- /.description-block -->
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                </div>
                <div class="box">
                    <div class="box-body box-profile">            
                        <div class="row">
                            <div class="col-12">
                                <div>
                                    <p>Email :<span class="text-gray ps-10">{{ Auth::user()->email }}</span> </p>
                                    <p>Phone :<span class="text-gray ps-10">{{ $profile->phone }}</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
            <div class="col-12 col-lg-7 col-xl-8">
                <div class="box">
                    <div class="box-header">
                        <h4>CHANGE PASSWORD</h4>
                    </div>
                    <div class="box-body box-profile">            
                        <div class="row">
                            <div class="col-12">
                                @if ($errors->any())
                                    @foreach ($errors->all() as $error)
                                    <div class="alert alert-danger alert-dismissible bg-body-secondary fade show" role="alert">{{$error}}</div>
                                    @endforeach
                                @endif
                                @if (session('status'))
                                    <div class="alert alert-success" role="alert">
                                        {{ session('status') }}
                                    </div>
                                @endif

                                <form method="POST" action="{{ route('password.update') }}">
                                    @csrf

                                    <div class="form-group row">
                                        <label for="current_password" class="col-md-4 col-form-label text-md-right">{{ __('Current Password') }}</label>

                                        <div class="col-md-6">
                                            <input id="current_password" type="password" class="form-control" name="current_password" required autocomplete="current-password">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('New Password') }}</label>

                                        <div class="col-md-6">
                                            <input id="password" type="password" class="form-control" name="password" required autocomplete="new-password">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('Confirm Password') }}</label>

                                        <div class="col-md-6">
                                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                                        </div>
                                    </div>

                                    <div class="form-group row mb-0">
                                        <div class="col-md-6 offset-md-4">
                                            <button type="submit" class="btn btn-primary">
                                                {{ __('Update Password') }}
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
        </div>
    </section>

</div>
@endsection