<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="dns-prefetch" href="//fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
        <!-- Vendors Style-->
        <link rel="stylesheet" href="{{ asset('admin/css/vendors_css.css') }}">

        <!-- Style-->  
        <link rel="stylesheet" href="{{ asset('admin/css/style.css') }}">
        <link rel="stylesheet" href="{{ asset('admin/css/skin_color.css') }}">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="{{ asset('assets/vendor_components/datatable/datatables.min.js') }}"></script>
    </head>
    <body class="hold-transition light-skin sidebar-mini theme-primary fixed">
        <div class="wrapper">
            <header class="main-header">
                <div class="d-flex align-items-center logo-box justify-content-start">	
                    <!-- Logo -->
                    <a href="{{ route('dashboard') }}" class="logo">
                        <!-- logo-->
                        <span class="dark-logo"><img class="img-fluid" style="max-width: 100px; margin-right: 3rem;" src="{{ asset('admin/smart-group.png') }}" alt="logo"></span>
                    </a>	
                </div>  
                <!-- Header Navbar -->
                <nav class="navbar navbar-static-top">
                    <!-- Sidebar toggle button-->
                    <div class="app-menu">
                        <ul class="header-megamenu nav">
                            <li class="btn-group nav-item">
                                <a href="#" class="waves-effect waves-light nav-link push-btn btn-primary-light" data-toggle="push-menu" role="button">
                                    <i class="icon-Menu"><span class="path1"></span><span class="path2"></span></i>
                                </a>
                            </li>
                        </ul> 
                    </div>

                    <div class="navbar-custom-menu r-side">
                        <ul class="nav navbar-nav">			
                            <!-- User Account-->
                            <li class="dropdown user user-menu">
                                <a href="#" class="waves-effect waves-light dropdown-toggle w-auto l-h-12 bg-transparent p-0 no-shadow" data-bs-toggle="dropdown" title="User">
                                    <div class="d-flex pt-1">
                                        <div class="text-end me-10">
                                            <p class="pt-5 fs-14 mb-0 fw-700 text-primary">{{ Auth::user()->name }}</p>
                                            <small class="fs-10 mb-0 text-uppercase text-mute">Admin</small>
                                        </div>
                                        <img src="{{ asset('assets/images/user.png') }}" class="avatar rounded-10 bg-primary-light h-40 w-40" alt="" />
                                    </div>
                                </a>
                                <ul class="dropdown-menu animated flipInX">
                                    <li class="user-body">
                                        <a class="dropdown-item" href="{{ route('investor.profile') }}"><i class="ti-user text-muted me-2"></i> Profile</a>
                                        <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();"><i class="ti-lock text-muted me-2"></i> Logout</a><form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                            @csrf
                                        </form>
                                    </li>
                                </ul>
                            </li>
                            <!-- Notifications -->
<!--                            <li class="dropdown notifications-menu">
                                <a href="#" class="waves-effect waves-light dropdown-toggle btn-info-light" data-bs-toggle="dropdown" title="Notifications">
                                    <i class="icon-Notification"><span class="path1"></span><span class="path2"></span></i>
                                </a>
                                <ul class="dropdown-menu animated bounceIn">
                                    <li class="header">
                                        <div class="p-20">
                                            <div class="flexbox">
                                                <div>
                                                    <h4 class="mb-0 mt-0">Notifications</h4>
                                                </div>
                                                <div>
                                                    <a href="#" class="text-danger">Clear All</a>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <li>
                                         inner menu: contains the actual data 
                                        <ul class="menu sm-scrol">
                                            <li>
                                                <a href="#">
                                                    <i class="fa fa-users text-info"></i> Curabitur id eros quis nunc suscipit blandit.
                                                </a>
                                            </li>
                                            <li>
                                                <a href="#">
                                                    <i class="fa fa-warning text-warning"></i> Duis malesuada justo eu sapien elementum, in semper diam posuere.
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class="footer">
                                        <a href="#">View all</a>
                                    </li>
                                </ul>
                            </li>-->

                        </ul>
                    </div>
                </nav>
            </header>
            
            <aside class="main-sidebar">
                <!-- sidebar-->
                <section class="sidebar position-relative">
                    <div class="multinav">
                        <div class="multinav-scroll" style="height: 100%;">	
                            <!-- sidebar menu-->
                            <ul class="sidebar-menu" data-widget="tree">			
                                <li>
                                    <a href="{{ route('investor.dashboard') }}">
                                        <i class="icon-Layout-4-blocks"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Dashboard</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('investor.deals') }}">
                                        <i class="icon-Settings-1"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Deals</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('investor.investments') }}">
                                        <i class="icon-Settings-1"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Investments</span>
                                    </a>
                                </li>	
                            </ul>

                        </div>
                    </div>
                </section>
            </aside>

            <main>
                <div class="content-wrapper">
                @yield('content')
                </div>
            </main>

            <footer class="main-footer">
                <div class="pull-right d-none d-sm-inline-block">
                    <ul class="nav nav-primary nav-dotted nav-dot-separated justify-content-center justify-content-md-end">
                        <li class="nav-item">
                            <a class="nav-link" href="#">Copy Rights</a>
                        </li>
                    </ul>
                </div>
                &copy; <script>document.write(new Date().getFullYear())</script> <a href="#">Multipurpose Themes</a>. All Rights Reserved.
            </footer>
        </div>

        <!-- Vendor JS -->
        <script src="{{ asset('admin/js/vendors.min.js') }}"></script>
        <script src="{{ asset('admin/js/pages/chat-popup.js') }}"></script>
        <script src="{{ asset('assets/icons/feather-icons/feather.min.js') }}"></script>
        

        <!-- Doclinic App -->
        <script src="{{ asset('admin/js/template.js') }}"></script>
        
        <script src="{{ asset('admin/js/custom.js') }}"></script>
    </body>
</html>
