<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\DealsController;
use App\Http\Controllers\Admin\InvestorsController;
use App\Http\Controllers\Auth\ChangePasswordController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Auth::routes();

Route::post('/404', [AdminController::class, 'errorpage'])->name('error.page');


Route::middleware(['auth'])->prefix('authentication')->group(function () {
    
    Route::post('/update-password', [ChangePasswordController::class, 'updatePassword'])->name('password.update');
    
});

Route::middleware(['auth', 'role:admin'])->prefix('admin')->group(function() {
    Route::get('/dashboard', [AdminController::class, 'index'])->name('dashboard');
    Route::get('/profile', [AdminController::class, 'profile'])->name('profile');
    
    Route::get('/admin/users', [AdminController::class, 'adminUsers'])->name('admin.users.list');
    Route::get('/add/admin/user', [AdminController::class, 'addAdminUsers'])->name('admin.users.add');
    Route::post('/store/admin/user', [AdminController::class, 'storeAdminUsers'])->name('admin.users.store');
    Route::post('/user/status', [AdminController::class, 'updateStatus'])->name('admin.user.status');

    //deals route
    Route::get('/deals', [DealsController::class, 'index'])->name('admin.deals.list');
    Route::get('/deals/create', [DealsController::class, 'create'])->name('admin.deals.create');
    Route::post('/deals', [DealsController::class, 'store'])->name('admin.deals.store');
    Route::get('/deals/edit/{deal}', [DealsController::class, 'edit'])->name('admin.deals.edit');
    Route::post('/deals/{deal}', [DealsController::class, 'update'])->name('admin.deals.update');
    Route::get('/deal/destroy/{deal}', [DealsController::class, 'destroy'])->name('admin.deals.destroy');
    Route::get('/deals/deatils/{deal}', [DealsController::class, 'dealDetails'])->name('admin.deal.deatails');
    Route::post('/deal/status', [DealsController::class, 'updateStatus'])->name('admin.deal.status');
    
    // deal documents
    Route::get('/deals/documents', [DealsController::class, 'documents'])->name('admin.deal.documents');
    Route::post('/store/deal/documents', [DealsController::class, 'storDocuments'])->name('admin.deal.documents.store');
    Route::get('/download/document/{filename}/{filetyp}', [DealsController::class, 'downloadDocument'])->name('admin.download.document');
    Route::get('/deal-document/destroy/{deal}', [DealsController::class, 'destroyDealDocument'])->name('admin.destroy.dealDocument');
    
    //investors data
    Route::get('/investors/add', [InvestorsController::class, 'add'])->name('add.investors');
    Route::post('/investors/save', [InvestorsController::class, 'saveInvestor'])->name('save.investors');
    Route::get('/investors/list', [InvestorsController::class, 'list'])->name('list.investors');
    Route::post('/investor/taxes', [InvestorsController::class, 'storDocuments'])->name('admin.investor.taxes');
    
    //assigning deals to investor
    Route::get('/investors/add/investment', [InvestorsController::class, 'addInvestment'])->name('add.investment');
    Route::post('/assign-deal/investor', [InvestorsController::class, 'assignDealToInvestor'])->name('admin.deal.assign.investor');
    Route::get('/destroy/assigned-deal/investor/{investment}', [InvestorsController::class, 'destroyInvestorDeal'])->name('admin.deal.assign.destroy');
    //edit investment details of investor
    Route::post('/get/investment/details', [InvestorsController::class, 'getInvestmentData'])->name('get.investment.data');
    Route::post('/update/investment/details', [InvestorsController::class, 'updateInvestmentData'])->name('update.investment');
    Route::get('/add/investor/taxes', [InvestorsController::class, 'addInvestorTaxes'])->name('add.investor.taxes');
    
    Route::get('/reports', [AdminController::class, 'getReports'])->name('admin.get.reports');

});

Route::middleware(['auth', 'role:investor'])->prefix('investor')->group(function () {
    

    Route::get('/dashboard', [App\Http\Controllers\Investor\InvestorController::class, 'index'])->name('investor.dashboard');
    Route::get('/profile', [App\Http\Controllers\Investor\InvestorController::class, 'profile'])->name('investor.profile');
    Route::get('/deals', [App\Http\Controllers\Investor\InvestorController::class, 'deals'])->name('investor.deals');
    Route::get('/deals/details/{deal}', [App\Http\Controllers\Investor\InvestorController::class, 'dealDeatils'])->name('investor.deal.details');
    Route::get('/investments', [App\Http\Controllers\Investor\InvestorController::class, 'investments'])->name('investor.investments');
    
    Route::get('/download/document/{filename}/{filetyp}', [App\Http\Controllers\Investor\InvestorController::class, 'downloadDocument'])->name('investor.download.document');
});







